//
//  QKBViewController.m
//  QuickKeyboard
//
//  Created by Jesse Allison on 8/1/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

//  Created in iOS Bootcamp 2012 April 2nd
//  Quick Implementation of a keyboard. 
//  This version uses the titleLabel of each key to load the appropriate
//  soundfile and play back the sound using the AVAudioPlayer

#import "QKBViewController.h"


@interface QKBViewController ()
        // ***** Create an AVAudioPlayer to use to play soundfiles ****** //
    @property (nonatomic, strong)   AVAudioPlayer   *player;
@end

@implementation QKBViewController
        // ***** Synthesize the AVAudioPlayer for access in the implementation ****** //
@synthesize player;


- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.
        
    // ***** Load the Audio Player with a file - repeat this code to load a different file ****** //
    
    // ***** Make an NSURL to read the soundfile from the mainBundle ****** //
    // ***** Make sure your soundfiles are added to the project and to: ****** //
    // ***** Keys4U (project) => Targets => Build Phases => Copy Bundle Resources ****** //
    NSURL *fileURL = [[NSURL alloc] initFileURLWithPath: [[NSBundle mainBundle] pathForResource:@"C" ofType:@"m4a"]];
            // ***** Load the player with the file... ****** //
    self.player = [[AVAudioPlayer alloc] initWithContentsOfURL:fileURL error:nil];  
    if (self.player)
    {
        player.numberOfLoops = 0;
    }
    // ******        **********************************      ****** //
}


# pragma mark - Respond to UI changes. . .

// ***** Connect these IBActions to respond to touch events on the keys in your view ****** //

        // ***** triggered from touch down ****** //
- (IBAction)playButtonPressed:(UIButton *)sender
{
                // Load Appropriate Soundfile based on key title. No title, no play.
    if(sender.titleLabel) {
        // ****** Using the title of the key to load the appropriate sound file ******* //
        NSURL *fileURL = [[NSURL alloc] initFileURLWithPath: [[NSBundle mainBundle] pathForResource:sender.titleLabel.text ofType:@"m4a"]];
        self.player = [[AVAudioPlayer alloc] initWithContentsOfURL:fileURL error:nil];  
        player.numberOfLoops = 0;

        [self startPlaybackForPlayer: player];
    }
}
        // ***** trigger from touch up inside and touch up outside ****** //
- (IBAction)playButtonReleased:(id)sender {
    [self stopPlaybackForPlayer: player];
}


        // **** made start and pause (stop) into their own methods ***** //
-(void)startPlaybackForPlayer:(AVAudioPlayer*)p
{
    // ***** Set the player to the beginning of the sound file and tell it to play... ****** //
    p.currentTime = 0.;
    [p play];
}

-(void)stopPlaybackForPlayer:(AVAudioPlayer*)p
{   // ***** Pause/Stop ****** //
    [p stop];
}

//- (IBAction)volumeSliderMoved:(UISlider *)sender
//{
//    player.volume = [sender value];
//}




# pragma mark - Lifecycle code

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPhone) {
        return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
    } else {
        return YES;
    }
}


@end
